/*
 * Decompiled with CFR 0.152.
 */
package script;

import java.util.Arrays;
import script.Syllabics;

public abstract class Roman {
    public static int V = 0;
    public static int C = 2;
    public static int NONUNICODE = 0;
    public static int UNICODE = 1;
    public static char[] apicals = new char[]{'t', 'l', 'j', '&', 's', 'n', 'd'};
    public static char[] bilabials = new char[]{'p', 'v', 'm', 'b'};
    public static char[] velars = new char[]{'k', 'g', 'N'};
    public static char[] uvulars = new char[]{'q', 'r'};

    static {
        Arrays.sort(apicals);
        Arrays.sort(bilabials);
        Arrays.sort(velars);
        Arrays.sort(uvulars);
    }

    public static boolean apicalConsonant(char car) {
        return Arrays.binarySearch(apicals, car) >= 0;
    }

    public static boolean bilabialConsonant(char car) {
        return Arrays.binarySearch(bilabials, car) >= 0;
    }

    public static boolean velarConsonant(char car) {
        return Arrays.binarySearch(velars, car) >= 0;
    }

    public static boolean uvularConsonant(char car) {
        return Arrays.binarySearch(uvulars, car) >= 0;
    }

    public static boolean longVowel(char car) {
        return Syllabics.Long.unicodeXsyl.get(new Character(car)) != null;
    }

    public static boolean shortVowel(char car) {
        return Syllabics.Short.unicodeXsyl.get(new Character(car)) != null;
    }

    public static boolean isSylCharacterA(char charac) {
        String c = (String)Syllabics.Short.unicodeXsyl.get(new Character(charac));
        return c != null && c.equals("a");
    }

    public static boolean isSylCharacterI(char charac) {
        String c = (String)Syllabics.Short.unicodeXsyl.get(new Character(charac));
        return c != null && c.equals("i");
    }

    public static boolean isSylCharacterU(char charac) {
        String c = (String)Syllabics.Short.unicodeXsyl.get(new Character(charac));
        return c != null && c.equals("u");
    }

    public static boolean sylWithSameVowel(char c1, char c2) {
        String sc1 = (String)Syllabics.unicodeXsyl.get(new Character(c1));
        String sc2 = (String)Syllabics.unicodeXsyl.get(new Character(c2));
        return sc1 != null && sc2 != null && sc1.length() > 1 && sc2.length() == 1 && sc1.charAt(sc1.length() - 1) == sc2.charAt(0);
    }

    public static char shortToLong(char v) {
        Character vc = new Character(v);
        String syl = (String)Syllabics.Short.unicodeXsyl.get(vc);
        if (syl != null) {
            String longsyl = String.valueOf(syl) + syl.charAt(syl.length() - 1);
            Character lvc = Syllabics.getCharacter(longsyl);
            if (lvc != null) {
                return lvc.charValue();
            }
            return '\uffff';
        }
        return '\uffff';
    }

    public static char[] longToDouble(char v) {
        String longsyl = (String)Syllabics.Long.unicodeXsyl.get(new Character(v));
        if (longsyl.length() == 3) {
            char[] va = new char[2];
            String shortsyl = longsyl.substring(0, 2);
            String vowel = longsyl.substring(2);
            if (shortsyl != null && vowel != null) {
                va[0] = Syllabics.getCharacter(shortsyl).charValue();
                va[1] = Syllabics.getCharacter(vowel).charValue();
                return va;
            }
            return null;
        }
        char[] va = new char[]{v};
        return va;
    }

    public static int typeOfLetterLat(char letter) {
        char[] consonants = new char[]{'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', '&', 'N', 'X', 'H'};
        char[] vowels = new char[]{'a', 'i', 'u'};
        Arrays.sort(consonants);
        Arrays.sort(vowels);
        if (Arrays.binarySearch(consonants, letter) >= 0) {
            return C;
        }
        if (Arrays.binarySearch(vowels, letter) >= 0) {
            return V;
        }
        return -1;
    }

    public static boolean isConsonant(char charac) {
        return Roman.typeOfLetterLat(charac) == C;
    }

    public static boolean isVowel(char charac) {
        return Roman.typeOfLetterLat(charac) == V;
    }

    public static boolean isInuktitutCharacter(char c) {
        return Syllabics.isInuktitutCharacter(c);
    }

    public static char nasalOfOcclusiveUnvoicedLat(char n) {
        if (n == 'p') {
            return 'm';
        }
        if (n == 't') {
            return 'n';
        }
        if (n == 'k') {
            return 'N';
        }
        if (n == 'q') {
            return 'r';
        }
        return '\uffff';
    }

    public static char voicedOfOcclusiveUnvoicedLat(char n) {
        if (n == 'p') {
            return 'v';
        }
        if (n == 't') {
            return 'l';
        }
        if (n == 'k') {
            return 'g';
        }
        if (n == 'q') {
            return 'r';
        }
        return '\uffff';
    }

    public static String orthographyOfVoiced(String voiced) {
        if (voiced.equals("b")) {
            return "p";
        }
        if (voiced.equals("d")) {
            return "t";
        }
        return voiced;
    }

    static String prepareString(String str) {
        String s = str.replaceAll("nng", "X");
        s = s.replaceAll("ng", "N");
        s = s.replaceAll("qq", "Q");
        s = s.replaceAll("rq", "Q");
        return s;
    }

    public static String transcodeToUnicode(String str, String aipaitaiMode) {
        String s = Roman.prepareString(str);
        int aipaitai = aipaitaiMode == null ? 0 : (aipaitaiMode.equals("aipaitai") ? 1 : 0);
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            int d;
            char c = s.charAt(i);
            block0 : switch (c) {
                case 'i': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                d = 5124;
                                break block0;
                            }
                        }
                        d = 5123;
                        --i;
                        break;
                    }
                    d = 5123;
                    --i;
                    break;
                }
                case 'u': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'u': {
                                d = 5126;
                                break block0;
                            }
                        }
                        d = 5125;
                        --i;
                        break;
                    }
                    d = 5125;
                    --i;
                    break;
                }
                case 'a': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'a': {
                                d = 5131;
                                break block0;
                            }
                            case 'i': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5121;
                                        break block0;
                                    }
                                }
                                d = 5130;
                                --i;
                                break block0;
                            }
                        }
                        d = 5130;
                        --i;
                        break;
                    }
                    d = 5130;
                    --i;
                    break;
                }
                case 'b': 
                case 'p': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5170;
                                            break block0;
                                        }
                                    }
                                    d = 5169;
                                    --i;
                                    break block0;
                                }
                                d = 5169;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5172;
                                            break block0;
                                        }
                                    }
                                    d = 5171;
                                    --i;
                                    break block0;
                                }
                                d = 5171;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5177;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5167;
                                                    break block0;
                                                }
                                            }
                                            d = 5176;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5176;
                                    --i;
                                    break block0;
                                }
                                d = 5176;
                                --i;
                                break block0;
                            }
                        }
                        d = 5193;
                        --i;
                        break;
                    }
                    --i;
                    d = 5193;
                    break;
                }
                case 'd': 
                case 't': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5199;
                                            break block0;
                                        }
                                    }
                                    d = 5198;
                                    --i;
                                    break block0;
                                }
                                d = 5198;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5201;
                                            break block0;
                                        }
                                    }
                                    d = 5200;
                                    --i;
                                    break block0;
                                }
                                d = 5200;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5206;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5196;
                                                    break block0;
                                                }
                                            }
                                            d = 5205;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5205;
                                    --i;
                                    break block0;
                                }
                                d = 5205;
                                --i;
                                break block0;
                            }
                        }
                        d = 5222;
                        --i;
                        break;
                    }
                    --i;
                    d = 5222;
                    break;
                }
                case 'k': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5230;
                                            break block0;
                                        }
                                    }
                                    d = 5229;
                                    --i;
                                    break block0;
                                }
                                d = 5229;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5232;
                                            break block0;
                                        }
                                    }
                                    d = 5231;
                                    --i;
                                    break block0;
                                }
                                d = 5231;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5235;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5227;
                                                    break block0;
                                                }
                                            }
                                            d = 5234;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5234;
                                    --i;
                                    break block0;
                                }
                                d = 5234;
                                --i;
                                break block0;
                            }
                        }
                        d = 5251;
                        --i;
                        break;
                    }
                    --i;
                    d = 5251;
                    break;
                }
                case 'g': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5260;
                                            break block0;
                                        }
                                    }
                                    d = 5259;
                                    --i;
                                    break block0;
                                }
                                d = 5259;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5262;
                                            break block0;
                                        }
                                    }
                                    d = 5261;
                                    --i;
                                    break block0;
                                }
                                d = 5261;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5265;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5257;
                                                    break block0;
                                                }
                                            }
                                            d = 5264;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5264;
                                    --i;
                                    break block0;
                                }
                                d = 5264;
                                --i;
                                break block0;
                            }
                        }
                        d = 5281;
                        --i;
                        break;
                    }
                    --i;
                    d = 5281;
                    break;
                }
                case 'm': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5286;
                                            break block0;
                                        }
                                    }
                                    d = 5285;
                                    --i;
                                    break block0;
                                }
                                d = 5285;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5288;
                                            break block0;
                                        }
                                    }
                                    d = 5287;
                                    --i;
                                    break block0;
                                }
                                d = 5287;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5291;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5283;
                                                    break block0;
                                                }
                                            }
                                            d = 5290;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5290;
                                    --i;
                                    break block0;
                                }
                                d = 5290;
                                --i;
                                break block0;
                            }
                        }
                        d = 5307;
                        --i;
                        break;
                    }
                    --i;
                    d = 5307;
                    break;
                }
                case 'n': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5315;
                                            break block0;
                                        }
                                    }
                                    d = 5314;
                                    --i;
                                    break block0;
                                }
                                d = 5314;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5317;
                                            break block0;
                                        }
                                    }
                                    d = 5316;
                                    --i;
                                    break block0;
                                }
                                d = 5316;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5320;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5312;
                                                    break block0;
                                                }
                                            }
                                            d = 5319;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5319;
                                    --i;
                                    break block0;
                                }
                                d = 5319;
                                --i;
                                break block0;
                            }
                        }
                        d = 5328;
                        --i;
                        break;
                    }
                    --i;
                    d = 5328;
                    break;
                }
                case 'h': 
                case 's': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5360;
                                            break block0;
                                        }
                                    }
                                    d = 5359;
                                    --i;
                                    break block0;
                                }
                                d = 5359;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5362;
                                            break block0;
                                        }
                                    }
                                    d = 5361;
                                    --i;
                                    break block0;
                                }
                                d = 5361;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5365;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5357;
                                                    break block0;
                                                }
                                            }
                                            d = 5364;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5364;
                                    --i;
                                    break block0;
                                }
                                d = 5364;
                                --i;
                                break block0;
                            }
                        }
                        d = 5381;
                        --i;
                        break;
                    }
                    --i;
                    d = 5381;
                    break;
                }
                case 'l': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5334;
                                            break block0;
                                        }
                                    }
                                    d = 5333;
                                    --i;
                                    break block0;
                                }
                                d = 5333;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5336;
                                            break block0;
                                        }
                                    }
                                    d = 5335;
                                    --i;
                                    break block0;
                                }
                                d = 5335;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5339;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5331;
                                                    break block0;
                                                }
                                            }
                                            d = 5338;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5338;
                                    --i;
                                    break block0;
                                }
                                d = 5338;
                                --i;
                                break block0;
                            }
                        }
                        d = 5354;
                        --i;
                        break;
                    }
                    --i;
                    d = 5354;
                    break;
                }
                case 'j': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5417;
                                            break block0;
                                        }
                                    }
                                    d = 5416;
                                    --i;
                                    break block0;
                                }
                                d = 5416;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5419;
                                            break block0;
                                        }
                                    }
                                    d = 5418;
                                    --i;
                                    break block0;
                                }
                                d = 5418;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5422;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5414;
                                                    break block0;
                                                }
                                            }
                                            d = 5421;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5421;
                                    --i;
                                    break block0;
                                }
                                d = 5421;
                                --i;
                                break block0;
                            }
                        }
                        d = 5438;
                        --i;
                        break;
                    }
                    --i;
                    d = 5438;
                    break;
                }
                case 'v': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5462;
                                            break block0;
                                        }
                                    }
                                    d = 5461;
                                    --i;
                                    break block0;
                                }
                                d = 5461;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5464;
                                            break block0;
                                        }
                                    }
                                    d = 5463;
                                    --i;
                                    break block0;
                                }
                                d = 5463;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5466;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5459;
                                                    break block0;
                                                }
                                            }
                                            d = 5465;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5465;
                                    --i;
                                    break block0;
                                }
                                d = 5465;
                                --i;
                                break block0;
                            }
                        }
                        d = 5469;
                        --i;
                        break;
                    }
                    --i;
                    d = 5469;
                    break;
                }
                case 'r': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5447;
                                            break block0;
                                        }
                                    }
                                    d = 5446;
                                    --i;
                                    break block0;
                                }
                                d = 5446;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5449;
                                            break block0;
                                        }
                                    }
                                    d = 5448;
                                    --i;
                                    break block0;
                                }
                                d = 5448;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5452;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5442;
                                                    break block0;
                                                }
                                            }
                                            d = 5451;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5451;
                                    --i;
                                    break block0;
                                }
                                d = 5451;
                                --i;
                                break block0;
                            }
                        }
                        d = 5456;
                        --i;
                        break;
                    }
                    --i;
                    d = 5456;
                    break;
                }
                case 'q': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5504;
                                            break block0;
                                        }
                                    }
                                    d = 5503;
                                    --i;
                                    break block0;
                                }
                                d = 5503;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5506;
                                            break block0;
                                        }
                                    }
                                    d = 5505;
                                    --i;
                                    break block0;
                                }
                                d = 5505;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5508;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5743;
                                                    break block0;
                                                }
                                            }
                                            d = 5507;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5507;
                                    --i;
                                    break block0;
                                }
                                d = 5507;
                                --i;
                                break block0;
                            }
                        }
                        d = 5509;
                        --i;
                        break;
                    }
                    --i;
                    d = 5509;
                    break;
                }
                case '&': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5537;
                                            break block0;
                                        }
                                    }
                                    d = 5536;
                                    --i;
                                    break block0;
                                }
                                d = 5536;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5539;
                                            break block0;
                                        }
                                    }
                                    d = 5538;
                                    --i;
                                    break block0;
                                }
                                d = 5538;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5541;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    sb.append('\u15a4');
                                                    d = 5123;
                                                    break block0;
                                                }
                                            }
                                            d = 5540;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5540;
                                    --i;
                                    break block0;
                                }
                                d = 5540;
                                --i;
                                break block0;
                            }
                        }
                        d = 5542;
                        --i;
                        break;
                    }
                    --i;
                    d = 5542;
                    break;
                }
                case 'N': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5520;
                                            break block0;
                                        }
                                    }
                                    d = 5519;
                                    --i;
                                    break block0;
                                }
                                d = 5519;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5522;
                                            break block0;
                                        }
                                    }
                                    d = 5521;
                                    --i;
                                    break block0;
                                }
                                d = 5521;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5524;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5744;
                                                    break block0;
                                                }
                                            }
                                            d = 5523;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5523;
                                    --i;
                                    break block0;
                                }
                                d = 5523;
                                --i;
                                break block0;
                            }
                        }
                        d = 5525;
                        --i;
                        break;
                    }
                    --i;
                    d = 5525;
                    break;
                }
                case 'X': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = 5746;
                                            break block0;
                                        }
                                    }
                                    d = 5745;
                                    --i;
                                    break block0;
                                }
                                d = 5745;
                                --i;
                                break block0;
                            }
                            case 'u': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = 5748;
                                            break block0;
                                        }
                                    }
                                    d = 5747;
                                    --i;
                                    break block0;
                                }
                                d = 5747;
                                --i;
                                break block0;
                            }
                            case 'a': {
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = 5750;
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    sb.append('\u1596');
                                                    d = 5257;
                                                    break block0;
                                                }
                                            }
                                            d = 5749;
                                            --i;
                                            break block0;
                                        }
                                    }
                                    d = 5749;
                                    --i;
                                    break block0;
                                }
                                d = 5749;
                                --i;
                                break block0;
                            }
                        }
                        d = 5526;
                        --i;
                        break;
                    }
                    --i;
                    d = 5526;
                    break;
                }
                case 'Q': {
                    char e;
                    sb.append('\u1585');
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'i': {
                                d = 5229;
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'i': {
                                            d = (char)(d + 1);
                                            break block0;
                                        }
                                    }
                                    --i;
                                    break block0;
                                }
                                --i;
                                break block0;
                            }
                            case 'u': {
                                d = 5231;
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'u': {
                                            d = (char)(d + 1);
                                            break block0;
                                        }
                                    }
                                    --i;
                                    break block0;
                                }
                                --i;
                                break block0;
                            }
                            case 'a': {
                                d = 5234;
                                if (++i < l) {
                                    e = s.charAt(i);
                                    switch (e) {
                                        case 'a': {
                                            d = (char)(d + 1);
                                            break block0;
                                        }
                                        case 'i': {
                                            switch (aipaitai) {
                                                case 1: {
                                                    d = 5227;
                                                    break block0;
                                                }
                                            }
                                            --i;
                                            break block0;
                                        }
                                    }
                                    --i;
                                    break block0;
                                }
                                --i;
                                break block0;
                            }
                        }
                        d = 5509;
                        --i;
                        break;
                    }
                    --i;
                    d = 5509;
                    sb.deleteCharAt(sb.length() - 1);
                    break;
                }
                case 'H': {
                    d = 5500;
                    break;
                }
                default: {
                    d = c;
                }
            }
            ++i;
            sb.append((char)d);
        }
        return sb.toString();
    }
}

